package doABC.Multiname;

import java.nio.ByteBuffer;
import java.util.ArrayList;
import doABC.CpoolInfo;
import FlashReader.SWF;
import FlashReader.SwfTools;

public class MultinameKindMultiname  extends SwfTools{

	private CpoolInfo cpool;
	
	private int start;
	private int end;
	//struktury
	private int name=-1;
	private int ns_set=-1;
	
	public MultinameKindMultiname(CpoolInfo cpool,int name, int ns_set){
		super();
		this.cpool = cpool;
		this.name=name;
		this.ns_set = ns_set;
	}

	public MultinameKindMultiname(ByteBuffer bbuf,CpoolInfo cpool){
		super();
		this.cpool = cpool;
		multiname_kind_Multiname(bbuf);
	}

	private void  multiname_kind_Multiname(ByteBuffer bbuf){
		
		start = bbuf.position();
		
		name = 	unsigned30int(bbuf);

		ns_set = 	unsigned30int(bbuf);
		
		end = bbuf.position()-1;
	
	
		
	}


	public int getStart() {
		return start;
	}


	public int getEnd() {
		return end;
	}



	public int getName() {
		return name;
	}


	public String getName_string() {
		if ( name ==0)
			return "*";
		return cpool.getStrings().get(name).getUtf8_string();

	}
	
	public int getNs_set() {
		return ns_set;
	}
	
	public ArrayList<String> getNs_set_string() {
		if ( ns_set ==0)
			return null;
		return cpool.getNsset().get(ns_set).getNs_string();
	}
	
	
	public String String(){
		String wynik ="";
		wynik+="\n---#--- option_info "+SWF.msgs.getString("Position")+": " + start + "\n\n";
			
		wynik+= "name: " + getName_string()+"\n";
		
		wynik+= "ns_set: " + getNs_set_string()+"\n";
			
		wynik+="\n---!!--- "+SWF.msgs.getString("Position")+":  "+end;
		
		return wynik;
		
		
	}
	
	public String toString(){
		String wynik ="";
		
		wynik += getName_string();

		return wynik;
	}
	
	public ArrayList<Byte> toByteCode(){
		ArrayList<Byte> result = new ArrayList<Byte>();
		
		if (  name!=-1){
			ArrayList<Byte> tmp =getUI32(name);
			for (int i=0;i<tmp.size();i++)
				result.add(tmp.get(i));
		}
		
		
		if (  ns_set!=-1){
			ArrayList<Byte> tmp =getUI32(ns_set);
			for (int i=0;i<tmp.size();i++)
				result.add(tmp.get(i));
		}
		
		return result;
	}
	
	
	
}
